<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class AuthController extends Controller
{
    public function showRegisterForm(){
        return view('admin.register');
    }

    public function register(Request $request){
        $request->validate([
            'username'=>'required|string|unique:users,username',
            'password'=>'required|string|min:4|confirmed'
        ]);

        $user = User::create([
            'username' => $request->username,
            'password' => Hash::make($request->password)
        ]);

        Auth::login($user);
        return redirect('/admin/dashboard');
    }

    public function showLoginForm(){
        return view('admin.login');
    }

    public function login(Request $request){
        $request->validate([
            'username'=>'required|string',
            'password'=>'required|string'
        ]);

        $user = User::where('username', $request->username)->first();

        if($user && Hash::check($request->password, $user->password)){
            Auth::login($user);
            return redirect('/admin/dashboard');
        }

        return back()->withErrors(['username'=>'Invalid credentials']);
    }

    public function dashboard(){
        return view('admin.dashboard');
    }

    public function logout(){
        Auth::logout();
        return redirect('/admin/login');
    }
}
