<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Blog;

class BlogController extends Controller
{
    // Home page ke liye blogs
    public function home()
    {
        // Latest 3 blogs fetch karo
        $blogs = Blog::latest()->take(3)->get();
        return view('home', compact('blogs'));
    }

    // All blogs page
    public function index()
    {
        $blogs = Blog::latest()->paginate(6);
        return view('frontend.blog.index', compact('blogs'));
    }

    // Single Blog Show (slug based)
    public function show($slug)
    {
        $blog = Blog::where('slug', $slug)->firstOrFail();
        return view('show', compact('blog')); // ✅ direct resources/views/show.blade.php
    }

    // ✅ /articles page ke liye
    public function articles()
    {
        $blogs = Blog::latest()->paginate(6);
        return view('blog', compact('blogs')); // resources/views/blog.blade.php
    }
}
