// admin-ajax.js
document.addEventListener("DOMContentLoaded", function () {
    const sidebarLinks = document.querySelectorAll(".sidebar a[data-url]");
    const mainContent = document.getElementById("mainContent");

    if (!mainContent) return;

    sidebarLinks.forEach(link => {
        link.addEventListener("click", function (e) {
            e.preventDefault();
            const url = this.getAttribute("data-url");

            if (!url) return;

            fetch(url)
                .then(response => {
                    if (!response.ok) throw new Error('Network response was not ok');
                    return response.text();
                })
                .then(html => {
                    mainContent.innerHTML = html;
                })
                .catch(error => {
                    mainContent.innerHTML = '<p class="text-danger">Content could not be loaded.</p>';
                    console.error("Error loading content:", error);
                });
        });
    });
});
