document.addEventListener("DOMContentLoaded", function () {
    const links = document.querySelectorAll(".sidebar a");
    const content = document.getElementById("mainContent");

    links.forEach(link => {
        link.addEventListener("click", function (e) {
            e.preventDefault();
            const url = this.getAttribute("data-url");

            if (url) {
                fetch(url)
                    .then(response => response.text())
                    .then(data => {
                        content.innerHTML = data;
                    })
                    .catch(error => {
                        content.innerHTML = "<p style='color:red'>Error loading content!</p>";
                    });
            }
        });
    });
});
