// Navbar Animation Example
document.addEventListener("DOMContentLoaded", function() {
    const brand = document.querySelector(".navbar-brand");
    brand.addEventListener("mouseover", () => {
        brand.style.color = "#FFCC66";
    });
    brand.addEventListener("mouseleave", () => {
        brand.style.color = "#fff";
    });
});

// Example AJAX Logout (Optional)
function logoutUser() {
    fetch("/admin/logout", {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content,
            "Content-Type": "application/json"
        },
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            window.location.href = "/admin/login";
        }
    });
}
