$(document).ready(function () {
    $('#contactForm').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: $(this).attr('action').split('#')[0], // remove #contact
            type: "POST",
            data: $(this).serialize(),
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function (response) {
                $('#formAlert').html('<div class="alert alert-success">' + response.message + '</div>');
                $('#contactForm')[0].reset();
            },
            error: function (xhr) {
                $('#formAlert').html('<div class="alert alert-danger">Something went wrong. Please try again.</div>');
            }
        });
    });
});
