document.addEventListener("DOMContentLoaded", function () {
  let slides = document.querySelectorAll(".hiring-slide");
  let currentIndex = 0;

  function showSlide(index) {
    slides.forEach((slide, i) => {
      slide.classList.remove("active");
      if (i === index) {
        slide.classList.add("active");
      }
    });
  }

  function nextSlide() {
    currentIndex = (currentIndex + 1) % slides.length;
    showSlide(currentIndex);
  }

  // Show first slide
  showSlide(currentIndex);

  // Auto slide every 3 seconds
  setInterval(nextSlide, 3000);
});
