<div class="d-flex justify-content-between mb-3">
    <h2>Blog List</h2>
    <button class="btn btn-primary btn-sm" onclick="loadContent('{{ route('blogs.create') }}')">Add Blog</button>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th><th>Title</th><th>Content</th><th>Image</th><th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($blogs as $blog)
        <tr>
            <td>{{ $blog->id }}</td>
            <td>{{ $blog->title }}</td>
            <td>{!! Str::limit($blog->content, 50) !!}</td>
            <td>
                @if($blog->image)
                    <img src="{{ asset('storage/'.$blog->image) }}" width="50">
                @else
                    No Image
                @endif
            </td>
            <td>
                <button class="btn btn-warning btn-sm" onclick="loadContent('{{ route('blogs.edit',$blog->id) }}')">Edit</button>
                <button class="btn btn-danger btn-sm" onclick="deleteBlog({{ $blog->id }})">Delete</button>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
