<div class="d-flex justify-content-between mb-3">
    <h2>Contact List</h2>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Message</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($contacts as $contact)
        <tr id="contactRow{{ $contact->id }}">
            <td>{{ $contact->id }}</td>
            <td>{{ $contact->name }}</td>
            <td>{{ $contact->email }}</td>
            <td>{{ $contact->phone ?? '-' }}</td>
            <td>{{ $contact->message }}</td>
            <td>
                <button class="btn btn-danger btn-sm" onclick="deleteContact({{ $contact->id }})">Delete</button>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>

<script>
function deleteContact(id) {
    if(!confirm('Are you sure you want to delete this contact?')) return;

    fetch('/admin/contacts/' + id, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            document.getElementById('contactRow'+id).remove();
        } else {
            alert('Failed to delete contact.');
        }
    })
    .catch(err => console.error(err));
}
</script>
