<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <meta name="csrf-token" content="{{ csrf_token() }}"> <!-- Important -->
    <title>@yield('title', 'Admin Panel')</title>
    
    <!-- jQuery (Summernote ko jQuery chahiye hota hai) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Summernote CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs5.min.css" rel="stylesheet">

<!-- Summernote JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs5.min.js"></script>


    <!-- Section CSS -->
    <link rel="stylesheet" href="{{ asset('admin/css/sidebar.css') }}">
    <link rel="stylesheet" href="{{ asset('admin/css/header.css') }}">
    <link rel="stylesheet" href="{{ asset('admin/css/footer.css') }}">
    <link rel="stylesheet" href="{{ asset('admin/css/dashboard.css') }}">
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        @include('admin.layouts.sidebar')

        <!-- Content Area -->
        <div class="content">
            @include('admin.layouts.header')

            <div class="main-content" id="mainContent">
                @yield('content')
            </div>

            @include('admin.layouts.footer')
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Section JS -->
    <script src="{{ asset('admin/js/sidebar.js') }}"></script>
    <script src="{{ asset('admin/js/header.js') }}"></script>
    <script src="{{ asset('admin/js/dashboard.js') }}"></script>
    <script src="{{ asset('admin/js/contentLoader.js') }}" defer></script>

    <!-- Section AJAX -->
    <script src="{{ asset('admin/ajax/dashboard-ajax.js') }}"></script>
    <script src="{{ asset('admin/ajax/contact-ajax.js') }}"></script>
</body>
