<section class="blog-section py-5" id="blog">
    <div class="container">
        <!-- Heading -->
        <div class="row mb-5 text-center">
            <div class="col">
                <h2 class="blog-heading">Latest Blog</h2>
                <p class="text-muted">Stay updated with our latest news & articles</p>
            </div>
        </div>

        <!-- Blog Cards -->
        <div class="row">
            @foreach($blogs as $index => $blog)
                <div class="col-md-4 mb-4" data-aos="fade-up" data-aos-delay="{{ ($index+1) * 100 }}">
                    <div class="blog-card">
                        <!-- Blog Image -->
                        <div class="blog-img">
                            @if($blog->image)
                                <img src="{{ asset('storage/'.$blog->image) }}" alt="{{ $blog->title }}">
                            @else
                                <img src="https://via.placeholder.com/400x250" alt="No Image">
                            @endif
                        </div>

                        <!-- Blog Content -->
                        <div class="blog-content">
                            <h5 class="blog-title">{{ $blog->title }}</h5>
                            <p class="blog-desc">{!! Str::limit(strip_tags($blog->content), 100) !!}</p>
                            <a href="{{ route('blogs.show', $blog->id) }}" class="btn btn-read">Read More</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Explore More Button -->
        <div class="row mt-4">
            <div class="col text-center">
                <a href="{{ url('/articles') }}" class="btn btn-read">Explore More</a>
            </div>
        </div>
    </div>
</section>
