@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <!-- Blog Card -->
            <div class="card shadow-lg border-0 rounded-3">
                @if($blog->image)
                    <img src="{{ asset('storage/'.$blog->image) }}" 
                         alt="{{ $blog->title }}" 
                         class="card-img-top img-fluid rounded-top"
                         style="max-height:400px; object-fit:cover;">
                @endif

                <div class="card-body p-4">
                    <!-- Blog Title -->
                    <h1 class="card-title fw-bold mb-3 text-center">{{ $blog->title }}</h1>

                    <!-- Divider -->
                    <hr class="my-4">

                    <!-- Blog Content -->
                    <div class="card-text fs-5 lh-lg text-muted">
                        {!! $blog->content !!}
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection
