<?php


use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\BlogController as AdminBlogController;
use App\Http\Controllers\Frontend\BlogController as FrontBlogController;
use App\Http\Controllers\ContactController;




// ------------------ Frontend Routes ------------------

Route::get('/', [FrontBlogController::class, 'home'])->name('home');
Route::get('/blogs', [FrontBlogController::class, 'index'])->name('blogs.index');
Route::get('/blogs/{id}', [FrontBlogController::class, 'show'])->name('blogs.show');

Route::get('/privacy-policy', function () {
    return view('privacy-policy');
});

Route::get('/terms-and-conditions', function () {
    return view('terms');
});

Route::get('/service-details', function () {
    return view('service');
});

Route::get('/articles', [FrontBlogController::class, 'articles'])->name('articles'); // ✅ isse $blogs pass hota

Route::get('/test-editor', function () {
    return view('test-editor');
});

Route::post('/contact', [ContactController::class, 'store'])->name('contact.store');

// Route::get('/blog/{slug}', [FrontBlogController::class, 'show'])->name('blog.show');

// ------------------ Frontend Routes ------------------
Route::get('/blogs', [FrontBlogController::class, 'index'])->name('frontend.blogs.index');
Route::get('/blogs/{slug}', [FrontBlogController::class, 'show'])->name('frontend.blogs.show');



// ------------------ Admin Routes ------------------
Route::prefix('admin')->group(function() {

    // ---------- Authentication ----------
    Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('admin.register');
    Route::post('/register', [AuthController::class, 'register']);
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('admin.login');
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('/dashboard', [AuthController::class, 'dashboard'])->middleware('auth');
    Route::post('/logout', [AuthController::class, 'logout'])->name('admin.logout');


Route::prefix('admin')->group(function () {
    Route::get('/dashboard-content', [AdminController::class, 'dashboardContent'])->name('admin.dashboardContent');
    Route::get('/header-content', [AdminController::class, 'headerContent'])->name('admin.headerContent');
    Route::get('/footer-content', [AdminController::class, 'footerContent'])->name('admin.footerContent');
    Route::get('/hero-content', [AdminController::class, 'heroContent'])->name('admin.heroContent');
    Route::get('/about-content', [AdminController::class, 'aboutContent'])->name('admin.aboutContent');
    Route::get('/services-content', [AdminController::class, 'servicesContent'])->name('admin.servicesContent');
    Route::get('/blog-content', [AdminController::class, 'blogContent'])->name('admin.blogContent');
    Route::get('/contact-content', [AdminController::class, 'contactContent'])->name('admin.contactContent');

  // Admin CRUD
 Route::resource('blogs', AdminBlogController::class);
  Route::resource('contact', ContactController::class)->only(['index', 'destroy']);
  

});

});
