<section id="contact" class="contact-section py-5">
  <div class="container">
    <!-- Heading -->
    <div class="text-center mb-5" data-aos="fade-up">
      <h2 class="fw-bold text-primary" style="color:#002060;">Contact Us</h2>
      <p class="text-muted">We’d love to hear from you</p>
    </div>

    <div class="row g-4">
      <!-- Left: Contact Info + Map -->
      <div class="col-lg-5" data-aos="fade-right">
        <div class="card shadow border-0 rounded-3 mb-4">
          <div class="card-body">
            <h5 class="fw-bold mb-3">Get in Touch</h5>
            <p class="mb-2"><i class="bi bi-geo-alt-fill text-primary me-2"></i> 123 Main Street, Kolkata, WB</p>
            <p class="mb-2">
              <i class="bi bi-telephone-fill text-primary me-2"></i> 
              <a href="tel:+919876543210" class="text-decoration-none">+91 98765 43210</a>
            </p>
            <p>
              <i class="bi bi-envelope-fill text-primary me-2"></i> 
              <a href="mailto:info@trinexa.com" class="text-decoration-none">info@trinexa.com</a>
            </p>
          </div>
        </div>

        <!-- Google Map -->
        <div class="shadow rounded-3 overflow-hidden">
          <iframe 
            src="<?php echo e(asset('img/mp.jpg')); ?>" 
            width="500" height="250" style="border:0;" allowfullscreen="" 
            loading="lazy" referrerpolicy="no-referrer-when-downgrade">
          </iframe>
        </div>
      </div>

      <!-- Right: Contact Form -->
      <div class="col-lg-7" data-aos="fade-left">
        <div class="card shadow border-0 rounded-3">
          <div class="card-body p-4">
            <h5 class="fw-bold mb-3">Send Us a Message</h5>
          <form id="contactForm" action="<?php echo e(route('contact.store')); ?>" method="POST" novalidate>
    <div class="row g-3">
        <div class="col-md-6">
            <input type="text" name="name" id="name" class="form-control" placeholder="Your Name" required>
        </div>
        <div class="col-md-6">
            <input type="email" name="email" id="email" class="form-control" placeholder="Your Email" required>
        </div>
        <div class="col-md-6">
            <input type="tel" name="phone" id="phone" class="form-control" placeholder="Your Phone">
        </div>
        <div class="col-12">
            <textarea name="message" id="message" class="form-control" rows="4" placeholder="Your Message" required></textarea>
        </div>
    </div>
    <button type="submit" class="btn btn-primary mt-3 w-100">Send Message</button>
</form>
<div id="formAlert"></div>

          </div>
        </div>
      </div>
    </div>

    <!-- Social Icons -->
    <div class="row mt-5 text-center" data-aos="fade-up">
      <div class="col">
        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
        <a href="#" class="social-icon"><i class="bi bi-instagram"></i></a>
        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
        <a href="#" class="social-icon"><i class="bi bi-whatsapp"></i></a>
      </div>
    </div>
  </div>
</section>
<?php /**PATH C:\xampp\htdocs\trinex\resources\views/sections/contact.blade.php ENDPATH**/ ?>