<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background-color: #003366;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .login-card {
            background: #ffffff;
            padding: 2rem;
            border-radius: 15px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0px 8px 25px rgba(0,0,0,0.2);
            animation: fadeIn 0.6s ease-in-out;
        }

        .login-card h2 {
            text-align: center;
            color: #003366;
            margin-bottom: 1.5rem;
        }

        .form-control {
            border-radius: 10px;
            padding-left: 40px;
        }

        .input-group-text {
            background: #003366;
            color: #fff;
            border: none;
            border-radius: 10px 0 0 10px;
        }

        .btn-login {
            background-color: #003366;
            color: white;
            border-radius: 10px;
            font-weight: bold;
            transition: all 0.3s ease;
        }

        .btn-login:hover {
            background-color: #FF9900;
            color: #fff;
            transform: translateY(-2px);
        }

        .error-msg {
            color: #FF0000;
            text-align: center;
            margin-top: 10px;
            font-size: 14px;
        }

        @keyframes fadeIn {
            from {opacity: 0; transform: scale(0.9);}
            to {opacity: 1; transform: scale(1);}
        }
    </style>
</head>
<body>
    <div class="login-card">
        <h2><i class="bi bi-shield-lock-fill"></i> Admin Login</h2>
        <form method="POST" action="<?php echo e(url('admin/login')); ?>">
            <?php echo csrf_field(); ?>

            <!-- Username -->
            <div class="input-group mb-3">
                <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
                <input type="text" name="username" class="form-control" placeholder="Username" required>
            </div>

            <!-- Password -->
            <div class="input-group mb-3">
                <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
                <input type="password" name="password" id="password" class="form-control" placeholder="Password" required>
                <span class="input-group-text" style="cursor: pointer;" onclick="togglePassword()">
                    <i class="bi bi-eye-fill" id="toggleIcon"></i>
                </span>
            </div>

            <!-- Button -->
            <button type="submit" class="btn btn-login w-100">Login</button>
        </form>

        <?php if($errors->any()): ?>
            <p class="error-msg"><?php echo e($errors->first()); ?></p>
        <?php endif; ?>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Password Toggle -->
    <script>
        function togglePassword() {
            let password = document.getElementById("password");
            let toggleIcon = document.getElementById("toggleIcon");

            if (password.type === "password") {
                password.type = "text";
                toggleIcon.classList.remove("bi-eye-fill");
                toggleIcon.classList.add("bi-eye-slash-fill");
            } else {
                password.type = "password";
                toggleIcon.classList.remove("bi-eye-slash-fill");
                toggleIcon.classList.add("bi-eye-fill");
            }
        }
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\trinex\resources\views/admin/login.blade.php ENDPATH**/ ?>