<div class="d-flex justify-content-between mb-3">
    <h2>Contact List</h2>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Message</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr id="contactRow<?php echo e($contact->id); ?>">
            <td><?php echo e($contact->id); ?></td>
            <td><?php echo e($contact->name); ?></td>
            <td><?php echo e($contact->email); ?></td>
            <td><?php echo e($contact->phone ?? '-'); ?></td>
            <td><?php echo e($contact->message); ?></td>
            <td>
                <button class="btn btn-danger btn-sm" onclick="deleteContact(<?php echo e($contact->id); ?>)">Delete</button>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<script>
function deleteContact(id) {
    if(!confirm('Are you sure you want to delete this contact?')) return;

    fetch('/admin/contacts/' + id, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            document.getElementById('contactRow'+id).remove();
        } else {
            alert('Failed to delete contact.');
        }
    })
    .catch(err => console.error(err));
}
</script>
<?php /**PATH C:\xampp\htdocs\trinex\resources\views/admin/contact/index.blade.php ENDPATH**/ ?>