<div class="d-flex justify-content-between mb-3">
    <h2>Blog List</h2>
    <button class="btn btn-primary btn-sm" onclick="loadContent('<?php echo e(route('blogs.create')); ?>')">Add Blog</button>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th><th>Title</th><th>Content</th><th>Image</th><th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($blog->id); ?></td>
            <td><?php echo e($blog->title); ?></td>
            <td><?php echo Str::limit($blog->content, 50); ?></td>
            <td>
                <?php if($blog->image): ?>
                    <img src="<?php echo e(asset('storage/'.$blog->image)); ?>" width="50">
                <?php else: ?>
                    No Image
                <?php endif; ?>
            </td>
            <td>
                <button class="btn btn-warning btn-sm" onclick="loadContent('<?php echo e(route('blogs.edit',$blog->id)); ?>')">Edit</button>
                <button class="btn btn-danger btn-sm" onclick="deleteBlog(<?php echo e($blog->id); ?>)">Delete</button>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php /**PATH C:\xampp\htdocs\trinex\resources\views/admin/blog/index.blade.php ENDPATH**/ ?>