<section class="blog-section py-5" id="blog">
    <div class="container">
        <!-- Heading -->
        <div class="row mb-5 text-center">
            <div class="col">
                <h2 class="blog-heading">Latest Blog</h2>
                <p class="text-muted">Stay updated with our latest news & articles</p>
            </div>
        </div>

        <!-- Blog Cards -->
        <div class="row">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4 mb-4" data-aos="fade-up" data-aos-delay="<?php echo e(($index+1) * 100); ?>">
                    <div class="blog-card">
                        <!-- Blog Image -->
                        <div class="blog-img">
                            <?php if($blog->image): ?>
                                <img src="<?php echo e(asset('storage/'.$blog->image)); ?>" alt="<?php echo e($blog->title); ?>">
                            <?php else: ?>
                                <img src="https://via.placeholder.com/400x250" alt="No Image">
                            <?php endif; ?>
                        </div>

                        <!-- Blog Content -->
                        <div class="blog-content">
                            <h5 class="blog-title"><?php echo e($blog->title); ?></h5>
                            <p class="blog-desc"><?php echo Str::limit(strip_tags($blog->content), 100); ?></p>
                            <a href="<?php echo e(route('blogs.show', $blog->id)); ?>" class="btn btn-read">Read More</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Explore More Button -->
        <div class="row mt-4">
            <div class="col text-center">
                <a href="<?php echo e(url('/articles')); ?>" class="btn btn-read">Explore More</a>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\trinex\resources\views/sections/blog.blade.php ENDPATH**/ ?>