

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <h1 class="text-center mb-5" style="color:#002060;">Latest Articles</h1>

    <div class="row g-4">
        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm border-0 rounded-3" 
                     style="transition: all 0.3s ease; background:#fff;">
                    
                    <!-- Blog Image -->
                    <?php if($blog->image): ?>
                        <img src="<?php echo e(asset('storage/'.$blog->image)); ?>" 
                             class="card-img-top mx-auto mt-3" 
                             style="width:25%; height:auto; object-fit:cover;" 
                             alt="<?php echo e($blog->title); ?>">
                    <?php else: ?>
                        <img src="https://via.placeholder.com/300x200" 
                             class="card-img-top mx-auto mt-3" 
                             style="width:25%; height:auto; object-fit:cover;" 
                             alt="No Image">
                    <?php endif; ?>

                    <div class="card-body text-center">
                        <!-- Blog Title -->
                        <h5 class="card-title" style="color:#002060;">
                            <?php echo e($blog->title); ?>

                        </h5>

                        <!-- Blog Excerpt -->
                        <p class="card-text text-muted">
                            <?php echo e(Str::limit(strip_tags($blog->content), 100)); ?>

                        </p>

                        <!-- Read More -->
                        <a href="<?php echo e(route('frontend.blogs.show', $blog->slug)); ?>" 
                           class="btn text-white px-4" 
                           style="background-color:#3399ff; border-radius:8px; transition:0.3s;">
                            Read More
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Pagination -->
    <div class="mt-5 d-flex justify-content-center">
        <?php echo e($blogs->links()); ?>

    </div>
</div>

<!-- Hover Effect -->
<style>
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(255, 153, 0, 0.6); /* Orange Shadow */
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\trinex\resources\views/blog.blade.php ENDPATH**/ ?>